/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs;

import com.lycanitesmobs.GuiHandler;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.capabilities.IExtendedPlayer;
import com.lycanitesmobs.core.entity.EntityCreatureBase;
import com.lycanitesmobs.core.info.Beastiary;
import com.lycanitesmobs.core.info.GroupInfo;
import com.lycanitesmobs.core.info.MobInfo;
import com.lycanitesmobs.core.item.ItemStaffSummoning;
import com.lycanitesmobs.core.network.MessagePetEntry;
import com.lycanitesmobs.core.network.MessagePetEntryRemove;
import com.lycanitesmobs.core.network.MessagePlayerStats;
import com.lycanitesmobs.core.network.MessageSummonSet;
import com.lycanitesmobs.core.network.MessageSummonSetSelection;
import com.lycanitesmobs.core.pets.DonationFamiliars;
import com.lycanitesmobs.core.pets.PetEntry;
import com.lycanitesmobs.core.pets.PetManager;
import com.lycanitesmobs.core.pets.SummonSet;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ExtendedPlayer
implements IExtendedPlayer {
    public static Map<EntityPlayer, ExtendedPlayer> clientExtendedPlayers = new HashMap<EntityPlayer, ExtendedPlayer>();
    public static Map<String, NBTTagCompound> backupNBTTags = new HashMap<String, NBTTagCompound>();
    public EntityPlayer player;
    public Beastiary beastiary;
    public GroupInfo beastiaryGroup;
    public MobInfo beastiaryCreature;
    public String beastiaryCategory;
    public PetManager petManager;
    public long currentTick = 0L;
    public boolean needsFirstSync = true;
    public byte controlStates = 0;
    public boolean hasAttacked = false;
    public int spiritCharge = 100;
    public int spiritMax;
    public int spirit = this.spiritMax = this.spiritCharge * 10;
    public int spiritReserved = 0;
    public int summonFocusCharge = 600;
    public int summonFocusMax;
    public int summonFocus = this.summonFocusMax = this.summonFocusCharge * 10;
    public Map<Integer, SummonSet> summonSets = new HashMap<Integer, SummonSet>();
    public int selectedSummonSet = 1;
    public int summonSetMax = 5;
    private boolean petManagerSetup = false;

    public static ExtendedPlayer getForPlayer(EntityPlayer player) {
        IExtendedPlayer iExtendedPlayer;
        if (player == null) {
            return null;
        }
        if (player.func_130014_f_() != null && player.func_130014_f_().field_72995_K) {
            if (clientExtendedPlayers.containsKey(player)) {
                ExtendedPlayer extendedPlayer = clientExtendedPlayers.get(player);
                extendedPlayer.setPlayer(player);
                return extendedPlayer;
            }
            ExtendedPlayer extendedPlayer = new ExtendedPlayer();
            extendedPlayer.setPlayer(player);
            clientExtendedPlayers.put(player, extendedPlayer);
        }
        if (!((iExtendedPlayer = (IExtendedPlayer)player.getCapability(LycanitesMobs.EXTENDED_PLAYER, null)) instanceof ExtendedPlayer)) {
            return null;
        }
        ExtendedPlayer extendedPlayer = (ExtendedPlayer)iExtendedPlayer;
        if (extendedPlayer.getPlayer() != player) {
            extendedPlayer.setPlayer(player);
        }
        return extendedPlayer;
    }

    public ExtendedPlayer() {
        this.beastiary = new Beastiary(this);
        this.petManager = new PetManager((EntityLivingBase)this.player);
    }

    public void backupPlayer() {
        if (this.player != null) {
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            this.writeNBT(nbtTagCompound);
            backupNBTTags.put(this.player.func_70005_c_(), nbtTagCompound);
        }
    }

    public void setPlayer(EntityPlayer player) {
        this.player = player;
        this.petManager.host = player;
        if (this.player.func_130014_f_() == null || this.player.func_130014_f_().field_72995_K) {
            return;
        }
        if (backupNBTTags.containsKey(this.player.func_70005_c_())) {
            this.readNBT(backupNBTTags.get(this.player.func_70005_c_()));
            backupNBTTags.remove(this.player.func_70005_c_());
        }
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public boolean canMeleeBigEntity(Entity targetEntity) {
        double range;
        double distance;
        if (targetEntity == null || !(targetEntity instanceof EntityLivingBase)) {
            return false;
        }
        float targetWidth = targetEntity.field_70130_N;
        float targetHeight = targetEntity.field_70131_O;
        if (targetEntity instanceof EntityCreatureBase) {
            EntityCreatureBase targetCreature = (EntityCreatureBase)targetEntity;
            targetWidth *= targetCreature.hitAreaWidthScale;
            targetHeight *= targetCreature.hitAreaHeightScale;
        }
        if (targetWidth <= 4.0f && targetHeight <= 4.0f) {
            return false;
        }
        double heightOffset = this.player.field_70163_u - targetEntity.field_70163_u;
        double heightCompensation = 0.0;
        if (heightOffset > 0.0) {
            heightCompensation = Math.min(heightOffset, (double)targetHeight);
        }
        return (distance = Math.sqrt(this.player.func_70068_e(targetEntity))) <= (range = 6.0 + heightCompensation + (double)(targetWidth / 2.0f));
    }

    public void meleeAttack(Entity targetEntity) {
        if (!this.hasAttacked && this.player.func_184614_ca() != null && this.canMeleeBigEntity(targetEntity)) {
            this.player.func_71059_n(targetEntity);
            this.player.func_184821_cY();
            this.player.func_184609_a(EnumHand.MAIN_HAND);
        }
    }

    public void onUpdate() {
        Object message;
        this.hasAttacked = false;
        boolean creative = this.player.field_71075_bZ.field_75098_d;
        boolean sync = false;
        this.spirit = Math.min(Math.max(this.spirit, 0), this.spiritMax - this.spiritReserved);
        if (this.spirit < this.spiritMax - this.spiritReserved) {
            ++this.spirit;
            if (!this.player.func_130014_f_().field_72995_K && this.currentTick % 20L == 0L || this.spirit == this.spiritMax - this.spiritReserved) {
                sync = true;
            }
        }
        this.summonFocus = Math.min(Math.max(this.summonFocus, 0), this.summonFocusMax);
        if (this.summonFocus < this.summonFocusMax) {
            ++this.summonFocus;
            if (!this.player.func_130014_f_().field_72995_K && !creative && this.currentTick % 20L == 0L || this.summonFocus < this.summonFocusMax || this.player.func_184614_ca() != null && this.player.func_184614_ca().func_77973_b() instanceof ItemStaffSummoning || this.player.func_184592_cb() != null && this.player.func_184592_cb().func_77973_b() instanceof ItemStaffSummoning) {
                sync = true;
            }
        }
        if (!this.player.func_130014_f_().field_72995_K && sync) {
            message = new MessagePlayerStats(this);
            LycanitesMobs.packetHandler.sendToPlayer((IMessage)message, (EntityPlayerMP)this.player);
        }
        if (!this.player.func_130014_f_().field_72995_K && !this.petManagerSetup) {
            Map<String, PetEntry> playerFamiliars = DonationFamiliars.instance.getFamiliarsForPlayer(this.player);
            if (playerFamiliars != null) {
                this.petManager.clearEntries("familiar");
                for (PetEntry petEntry : playerFamiliars.values()) {
                    if (this.petManager.hasEntry(petEntry)) continue;
                    this.petManager.addEntry(petEntry);
                    petEntry.entity = null;
                }
                this.sendPetEntriesToPlayer("familiar");
            }
            this.petManagerSetup = true;
        }
        if (!this.player.func_130014_f_().field_72995_K && this.needsFirstSync) {
            this.beastiary.sendAllToClient();
            this.sendAllSummonSetsToPlayer();
            message = new MessageSummonSetSelection(this);
            LycanitesMobs.packetHandler.sendToPlayer((IMessage)message, (EntityPlayerMP)this.player);
        }
        this.petManager.onUpdate(this.player.func_130014_f_());
        ++this.currentTick;
        this.needsFirstSync = false;
    }

    public SummonSet getSummonSet(int setID) {
        if (setID <= 0) {
            LycanitesMobs.printWarning("", "Attempted to access set " + setID + " but the minimum ID is 1. Player: " + this.player);
            return null;
        }
        if (setID > this.summonSetMax) {
            LycanitesMobs.printWarning("", "Attempted to access set " + setID + " but the maximum set ID is " + this.summonSetMax + ". Player: " + this.player);
            return null;
        }
        if (!this.summonSets.containsKey(setID)) {
            this.summonSets.put(setID, new SummonSet(this));
        }
        return this.summonSets.get(setID);
    }

    public SummonSet getSelectedSummonSet() {
        if (this.selectedSummonSet != this.validateSummonSetID(this.selectedSummonSet)) {
            this.setSelectedSummonSet(this.selectedSummonSet);
        }
        return this.getSummonSet(this.selectedSummonSet);
    }

    public void setSelectedSummonSet(int targetSetID) {
        this.selectedSummonSet = targetSetID = this.validateSummonSetID(targetSetID);
    }

    public int validateSummonSetID(int targetSetID) {
        for (targetSetID = Math.max(Math.min(targetSetID, this.summonSetMax), 1); !this.getSummonSet(targetSetID).isUseable() && targetSetID > 1; --targetSetID) {
        }
        return targetSetID;
    }

    public Beastiary getBeastiary() {
        return this.beastiary;
    }

    public void onDeath() {
    }

    public void sendPetEntriesToPlayer(String entryType) {
        if (this.player.func_130014_f_().field_72995_K) {
            return;
        }
        for (PetEntry petEntry : this.petManager.allEntries.values()) {
            if (!entryType.equals(petEntry.getType()) && !"".equals(entryType)) continue;
            MessagePetEntry message = new MessagePetEntry(this, petEntry);
            LycanitesMobs.packetHandler.sendToPlayer(message, (EntityPlayerMP)this.player);
        }
    }

    public void sendPetEntryToPlayer(PetEntry petEntry) {
        if (this.player.func_130014_f_().field_72995_K) {
            return;
        }
        MessagePetEntry message = new MessagePetEntry(this, petEntry);
        LycanitesMobs.packetHandler.sendToPlayer(message, (EntityPlayerMP)this.player);
    }

    public void sendPetEntryToServer(PetEntry petEntry) {
        if (!this.player.func_130014_f_().field_72995_K) {
            return;
        }
        MessagePetEntry message = new MessagePetEntry(this, petEntry);
        LycanitesMobs.packetHandler.sendToServer(message);
    }

    public void sendPetEntryRemoveRequest(PetEntry petEntry) {
        if (!this.player.func_130014_f_().field_72995_K) {
            return;
        }
        petEntry.remove();
        MessagePetEntryRemove message = new MessagePetEntryRemove(this, petEntry);
        LycanitesMobs.packetHandler.sendToServer(message);
    }

    public void sendAllSummonSetsToPlayer() {
        if (this.player.func_130014_f_().field_72995_K) {
            return;
        }
        for (byte setID = 1; setID <= this.summonSetMax; setID = (byte)(setID + 1)) {
            MessageSummonSet message = new MessageSummonSet(this, setID);
            LycanitesMobs.packetHandler.sendToPlayer(message, (EntityPlayerMP)this.player);
        }
    }

    public void sendSummonSetToServer(byte setID) {
        if (!this.player.func_130014_f_().field_72995_K) {
            return;
        }
        MessageSummonSet message = new MessageSummonSet(this, setID);
        LycanitesMobs.packetHandler.sendToServer(message);
    }

    public void updateControlStates(byte controlStates) {
        this.controlStates = controlStates;
    }

    public boolean isControlActive(CONTROL_ID controlID) {
        return (this.controlStates & controlID.id) > 0;
    }

    public void requestGUI(byte guiID) {
        if (guiID == GuiHandler.PlayerGuiType.PET_MANAGER.id) {
            this.sendPetEntriesToPlayer("pet");
        }
        if (guiID == GuiHandler.PlayerGuiType.MOUNT_MANAGER.id) {
            this.sendPetEntriesToPlayer("mount");
        }
        if (guiID == GuiHandler.PlayerGuiType.FAMILIAR_MANAGER.id) {
            this.sendPetEntriesToPlayer("familiar");
        }
    }

    public void readNBT(NBTTagCompound nbtTagCompound) {
        NBTTagCompound extTagCompound = nbtTagCompound.func_74775_l("LycanitesMobsPlayer");
        this.beastiary.readFromNBT(extTagCompound);
        this.petManager.readFromNBT(extTagCompound);
        if (extTagCompound.func_74764_b("SummonFocus")) {
            this.summonFocus = extTagCompound.func_74762_e("SummonFocus");
        }
        if (extTagCompound.func_74764_b("Spirit")) {
            this.spirit = extTagCompound.func_74762_e("Spirit");
        }
        if (extTagCompound.func_74764_b("SelectedSummonSet")) {
            this.selectedSummonSet = extTagCompound.func_74762_e("SelectedSummonSet");
        }
        if (extTagCompound.func_74764_b("SummonSets")) {
            NBTTagList nbtSummonSets = extTagCompound.func_150295_c("SummonSets", 10);
            for (int setID = 0; setID < this.summonSetMax; ++setID) {
                NBTTagCompound nbtSummonSet = nbtSummonSets.func_150305_b(setID);
                SummonSet summonSet = new SummonSet(this);
                summonSet.readFromNBT(nbtSummonSet);
                this.summonSets.put(setID + 1, summonSet);
            }
        }
    }

    public void writeNBT(NBTTagCompound nbtTagCompound) {
        NBTTagCompound extTagCompound = new NBTTagCompound();
        this.beastiary.writeToNBT(extTagCompound);
        this.petManager.writeToNBT(extTagCompound);
        extTagCompound.func_74768_a("SummonFocus", this.summonFocus);
        extTagCompound.func_74768_a("Spirit", this.spirit);
        extTagCompound.func_74768_a("SelectedSummonSet", this.selectedSummonSet);
        NBTTagList nbtSummonSets = new NBTTagList();
        for (int setID = 0; setID < this.summonSetMax; ++setID) {
            NBTTagCompound nbtSummonSet = new NBTTagCompound();
            SummonSet summonSet = this.getSummonSet(setID + 1);
            summonSet.writeToNBT(nbtSummonSet);
            nbtSummonSets.func_74742_a((NBTBase)nbtSummonSet);
        }
        extTagCompound.func_74782_a("SummonSets", (NBTBase)nbtSummonSets);
        nbtTagCompound.func_74782_a("LycanitesMobsPlayer", (NBTBase)extTagCompound);
    }

    public static enum CONTROL_ID {
        JUMP(1),
        MOUNT_ABILITY(2),
        MOUNT_INVENTORY(4),
        ATTACK(8);

        public byte id;

        private CONTROL_ID(byte i) {
            this.id = i;
        }
    }
}

